/* main for flatten routine -- used for modifications to allow
   argument based selection of reference points. Original version from
   Rick Ebert..
   usage for the program : flatten -[ps] -r MIN MAX -i MIN MAX infile outfile
                      or   flatten -[ps] -[ri] MIN MAX infile outfile

   Selects reference points as a function of their position in the image
   pixel value distribution. If the -p mode is selected, all reference 
   points are selected within the window MIN MAX percentile of the image
   values. The histogram of image values is based on all points or on
   +5 sigma to =5 sigma points, which ever range is more compact.

   The repeat passes are designed to allow for a more reliable background
   subtraction. The first pass ( asked for with the -r flag, or reject flag )
   is used to fit a plane to the image to remove easily identified bulk trends
   in the image. The initial fitting allows for the second pass to more 
   reliably determine true background points. Arguments for the first pass
   should be set to prevent deviant pixel values from distorting the  fit,
   while the window for the second pass should be set to select some of the
   smaller values of the image for the background points. 

   Requires the files:  conduct.c flatten.c istat.c ihist.c ptile.c  

   The necessary modifications to those routines by B. Penprase and R. Ebert. */
/*
 * Copyright (C) 1992, California Institute of Technology.
 * U.S. Government Sponsorship under NASA Contract NAS7-918
 * is acknowledged.
 */
/* command line parameter fetching routine */
/* debug stuff too */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include "squawk.h"
#include "flatten.h"

#define F_REJECT 2
#define F_INCLUDE 4
#define F_SIGMA 8
#define F_PTILE 16


int debug;    /* any routine in the package needs access to this. */
int rmode ;

main(argc,argv)
int argc;
char *argv[];
{

    char strbuf[BUFSIZ], infilnam[BUFSIZ], outfilnam[BUFSIZ];
    char *bufptr;
    char *cptr, *index();
    int *arrayptr;
    int nints, howmany;
    int point_counter;
    int realloc_counter;
    int points_to_go;
    float  rsigu,rsigl,isigu,isigl ;
    /* for debugging */
    int di, *diptr;

 /*   debug = 13; */
    debug= 0. ;
    rmode = 0 ;
    rsigu = 0.;
    rsigl = 0.;
    isigu = 0.;
    isigl = 0.;

    /* enforce correct number of arguments */
    if (argc > 5 && argc < 11 ) { 

    /* The function is invoked by 
            flatten -p -r N1 N2 -i N1 N2 infile outfile or by
            flatten -s -r N1 N2 -i N1 N2 infile outfile.
      The first of these does two iterations; it includes points from
      percentile N1 to N2, fits them, and then refits the fitted image
      using only points  from percentile N1 to N2.
      The second call uses multiples of sigma -- N1 and N2 to do the
      same sort of thing. The program may also be called with 
              flatten -p -r N1 N2 infile outfile, for a single pass
      through the fitting. */
       

        /* enforce correct form of first two arguments */
        if (argv[1][1] == 'p' || argv[1][1] == 's'  && 
                     argv[2][1] == 'i' || argv[2][1] == 'r'
		     && argv[2][0] == '-' && argv[1][0] == '-') 
        {

        /* find from argument whether to use percentile or sigma mode */

        if (argv[1][1] == 'p') {
                        rmode = F_PTILE ;
                               }
        else                   {
                        rmode = F_SIGMA ;
                               }

        /* now find thresholds of reject and include values */

             if (argv[2][1] == 'r') 
             {
                 /* reject mode */
               rmode = F_REJECT ;
               rsigl = atof(argv[3]) ;
               rsigu = atof(argv[4]) ;
                 if (argv[5][1] == 'i' && argv[5][0] == '-') 
                 {
                   rmode = (F_REJECT|F_INCLUDE) ;
                   isigl = atof(argv[6]) ;
                   isigu = atof(argv[7]) ;
                 strcpy(infilnam, argv[8]) ;
                 strcpy(outfilnam, argv[9]) ;
                  }
                 else  { 
                 strcpy(infilnam, argv[5]) ;
                 strcpy(outfilnam, argv[6]) ;
                       }

             }
             else
             {
                 /* include mode */
               rmode = F_INCLUDE ;
               isigl = atof(argv[3]) ;
               isigu = atof(argv[4]) ;
                 if (argv[5][1] == 'r' && argv[5][0] == '-') 
                 {
                   rmode = (F_REJECT|F_INCLUDE) ;
                   rsigl = atof(argv[6]) ;
                   rsigu = atof(argv[7]) ;
                 strcpy(infilnam, argv[8]) ;
                 strcpy(outfilnam, argv[9]) ;
                 }
                 else  { fprintf(stderr,"getfnames(4,5,infilnam,outfilnam)\n"); 
                 strcpy(infilnam, argv[5]) ;
                 strcpy(outfilnam, argv[6]) ;
                        }
              }
        }

    /* Error messages */

        else {
     fprintf(stderr,"%s needs to be invoked with %s -[is] -[ir] MIN MAX -[ir] MIN MAX infile outfile\n", argv[0], argv[0]); 
         exit(1);
	   }
	}
        else {
     fprintf(stderr,"%s needs at least 5 arguments, as in %s -[is] -[ir] MIN MAX infile outfile\n", argv[0], argv[0]);
             }

     

/* ----------------------------- Begin old code -------------------------- */
    if(debug) fprintf(stderr,"Debug set to %d\n", debug);
   
    if((bufptr = malloc(STARTPTS * INTSPERPT * sizeof(int))) == (char *) NULL){
	fprintf(stderr,"No space to store reference points!\n");
	exit(1);
	}


    arrayptr = (int *) bufptr;
    point_counter = 0;
    realloc_counter = 0;
    points_to_go = STARTPTS;


     if(conductor(infilnam, outfilnam, isigl, isigu, rsigl, rsigu) != 0)
       fprintf(stderr, "Flatten didn't work.\n"); 

    free(bufptr);
    exit(0);
}
      
   
