/*  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	istats  - computes statistics over the pixels of an image

		- dead pix code added 8//26/91

						gene kopan   ipac/cit
						started      12/01/90
     Modified to be compatible with flatten -- B. Penprase 6/10/92
     Modified to avoid blank pixels -- Booth Hartley 10/18/96
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/*
 * Copyright (C) 1992, California Institute of Technology.
 * U.S. Government Sponsorship under NASA Contract NAS7-918
 * is acknowledged.
 */
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <values.h>
#include "imaginfo.h"

#ifndef MAXDOUBLE
#include <float.h>
#define MAXDOUBLE DBL_MAX
#define MAXFLOAT FLT_MAX
#endif


#define max( a,b ) 	((a) > (b) ? (a) : (b))
#define min( a,b ) 	((a) < (b) ? (a) : (b))

istats( nl, nc, pix, pave, psig, pmin, pmax )

/*		arguments:
			nl,nc	number of lines & columns in image
			pix	PIXEL pointer to pixel array
			pave	float pointer to computed average
			psig	float pointer to computed std. deviation
			pmin	float pointer to computed minimum
			pmax	float pointer to computed maximum
*/

int nl,nc;
PIXEL *pix;
float *pave,*psig,*pmax,*pmin;
{
	int il,ic,ipix,npix;
	double sum,sum2,val;
        PIXEL *pixptr;

        pixptr = pix ;
	sum = sum2 = 0.;
	npix= 0;
	*pmin = MAXFLOAT;
	*pmax = -MAXFLOAT;

	for( il= 0; il<nl; il++ )
		for( ic= 0; ic<nc; ic++)
		{
                        pixptr = pix + ic + il*nc ;
			val  =  *pixptr ;

			  if (finite(val))
			  {
			  sum += val;  sum2 += val*val; npix++;
			  *pmax = max( *pmax, val );
			  *pmin = min( *pmin, val );
			  }
		}
	sum = sum/npix;    sum2 = (sum2 - sum*sum*npix)/(npix+1);
	if( sum2 > 0. ) sum2 = sqrt( sum2 );
	*pave = sum; *psig = sum2;
        fprintf (stderr,"pmax and pmin are set to: %f\n",*pmax);
		
}
