/*  ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
	ihist   - computes histogram of the pixels of an image

		- dead pix code added 8/26/91

						gene kopan   ipac/cit
						started      12/02/90
    Modified to be compatible with flatten -- B. Penprase 6/10/92
    ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
/*
 * Copyright (C) 1992, California Institute of Technology.
 * U.S. Government Sponsorship under NASA Contract NAS7-918
 * is acknowledged.
 */

#include <math.h>
#include <stdio.h>
#include "imaginfo.h"


ihist( nl, nc, pix, bot, res, nh, pntot, ph )

/*		arguments:
			nl,nc	number of lines & columns in image
			pix	float pointer to pixel array
			bot 	bottom of histogram
			res	histogram resolution
			nh	number of bins in histogram
			pntot	int pointer to computed counts in histo
			ph	int pointer to histogram array pointer
*/

int	nl,nc,nh,**ph,*pntot;
PIXEL   *pix ;
float	bot,res;
{
	int il,ic,ipix,*h;
	int *malloc();
	float val;
	PIXEL *pixptr ;

	h = *ph = malloc( 4*nh );
	res = 1./res; *pntot = 0;
	for( il= 0; il<nh; il++) h[il]= 0;
	for( il= 0; il<nl; il++ )
		for( ic= 0; ic<nc; ic++)
		{
		   pixptr = pix + ic + il*nc ;
		   val = *pixptr ;
		   if( val == val )
		   {
			ipix =  (val-bot)*res;
			if( ipix < 0 ) ipix = 0;
			else if( ipix >= nh ) ipix = nh-1;
			h[ipix]++; (*pntot)++;
		   }
		}
}
