/* conduct.c :: handles application specific setup and takedown of
 *               images, that is the before and after housekeeping
 *               chores involved with getting images to and from,
 *               a unary operator (the engine).
 *
 *    Rick Ebert  October,1987       rick@ipac.caltech.edu
 *     modified to use the New image i/o routines: October, 1988
 *
 *   modified by B. Penprase June 9, 1992 to select points on the basis
 *   of a window of std-deviations from the average value of the image,
 *   or for percentile selections.
 *
 * Copyright (C) 1992, California Institute of Technology.
 * U.S. Government Sponsorship under NASA Contract NAS7-918
 * is acknowledged.
 *
 */
#include <stdio.h>
#include <math.h>
#include <sys/time.h>
#include <sys/resource.h>
#include "squawk.h"
#include "imaginfo.h"
#define  HIST_VER  "V1.1"  /* version number that goes in image headers */
#include "flatten.h"
#define F_REJECT 2
#define F_INCLUDE 4
#define F_SIGMA 8
#define F_PTILE 16


int
conductor(ifilname, ofilname, isigl, isigu, rsigl, rsigu)
char *ifilname, *ofilname;
float isigl,isigu,rsigl,rsigu ;
{

	int fids[2];
	int counter;
        int sx,sy,il,ic ;
        float val, uwind, lwind ;
	float res, tile, percent; 
	int nh=100000,ntot,*h;
        int array[500000];
        float ave,sig,bot,top ;
	char *bufptr, *malloc();
	PIXEL *pixptr;
        PIXEL *pixsel;
        PIXEL *inpix;
        struct imaginfo  inputimag, outputimag;
	int axis_size[2];
	int flatten();
	/* version number for HISTORY card */
        static char history_version[] = HIST_VER ;
	char string[81];

        struct rlimit resorc;

        extern int debug;  /* main set this up for us */
        extern int rmode;  /* main set this up for us */
	int intdebug, i, j;      /* for storing return codes etc. debug use */
	int npixels, npoints, narefs;
        narefs = 0 ;

	if((inputimag.fid =im_open(ifilname, READ))  < 0)
		squawk(Terminal, "Error opening input file");

        /* open output file */
	if((outputimag.fid =im_open(ofilname, WRITE))  < 0)
		squawk(Terminal, "Error opening input file");

/* get generally useful image information                    */

        if(getimaginfo(&inputimag) != 2)
	   squawk(Terminal,"Input must 2 dimensional image or subimage");
       
	npixels = inputimag.npixels;

	nlengths(&inputimag, axis_size, 2); /* get # samples, # lines */

/* Set-up more of the inputimag struct */

	outputimag.blank = inputimag.blank;
        inputimag.bscale = 1;
	inputimag.b_zero  = 0;
	outputimag.npixels = inputimag.npixels;

/* create some space to read in the pixels    */

	if(npixels > 1000000){ /* That's four MB of image memory */
	   getrlimit(RLIMIT_DATA, &resorc);
	   resorc.rlim_cur = resorc.rlim_max ;
           setrlimit(RLIMIT_DATA, &resorc);
         }
	if(debug >5) fprintf(stderr,"Going to malloc pixptr\n");
	if((bufptr = malloc(npixels * SIZPIXEL)) == (char *) 0)
		squawk(Terminal, "Can't get enough image memory");

	pixptr = (PIXEL *) bufptr;  /* pixptr points to pixel buffer */

/* read in the pixels */

	if(debug >5) fprintf(stderr,"Going to read pixels\n");
	if(im_rpix_r(inputimag.fid, pixptr, npixels) != npixels)
		squawk(Terminal, "Error reading pixels");
#ifdef DEBUG
     inpix = pixptr; /* set */
 if(debug == 12){
        fprintf(stderr,"conductor: debug: Print out all pixels going in...\n");
 for (j = 0 ; j < inputimag.naxis[2]; j++)          /* the lines */
   for(i = 0; i < inputimag.naxis[1]; i++)          /* the samples */
     fprintf(stderr,"%f ", *inpix++);
     fprintf(stderr,"\nEnd of input pixel buffer\n");
     inpix = pixptr; /* reset after use */
  }
#endif
	/* copy input header to output image...*/

	if(debug >5) fprintf(stderr,"Copy header...\n");
	fids[0]=inputimag.fid;
	fids[1]=0;
	im_hdr(outputimag.fid, fids, (char *) 0);

/* perform the operation on the pixel buffer (*pixptr) here */

/* Begin new code here.. Selects for points in the reject and include windows */

              sx = axis_size[0] ;
              sy = axis_size[1] ;

/* Begin reject pass through data */

        if (rmode & F_REJECT)
                {
		/* get statistics for image */

                istats (sy,sx, pixptr, &ave, &sig, &bot, &top) ;
                fprintf(stderr, "stats for image: ave %f sig %f bot %f top %f\n", ave,sig,bot,top);

 /* Set selection window based on either sigma or ptile mode */

		if (rmode & F_SIGMA) { /* sigma mode */
                           uwind = ave+rsigu*sig ;
                           lwind = ave+rsigl*sig ;
         fprintf(stderr, "Upper window is : %f \n",uwind);
         fprintf(stderr, "Lower window is : %f \n",lwind);
				     }

                 else               {   /* percentile mode */

		res = ave - 5.0*sig; if( bot < res) bot = res ;
		res = ave + 5.0*sig; if( top < res) top = res ;
		res = (top-bot)/nh ;

                ihist (sy,sx, pixptr, bot, res, nh, &ntot, &h) ;
		percent = rsigl/100. ;
		ptile (nh,h,ntot,percent,&tile) ;
		lwind = tile*res + bot ;
		percent = rsigu/100. ;
		ptile (nh,h,ntot,percent,&tile) ;
		uwind = tile*res + bot ;

    fprintf(stderr, "Upper window from %f percentile is : %f \n",rsigu,uwind);
    fprintf(stderr, "Lower window from %f percentile is : %f \n",rsigl,lwind);
				    }

                    narefs = 0 ;
                    for (il=0; il < sy; il++ )
                        for (ic=0; ic < sx; ic++)
                        {
                           pixsel = pixptr + ic + il*sx ;
                           val = *pixsel ;
                           if (val <= uwind && val >= lwind)
                           {
                            array[narefs++] = ic+1 ; 
                            array[narefs++] = il+1 ; 
                           }
                        }
                     npoints = narefs/2 ;
         fprintf(stderr, "Number of reference points used is: %d\n",npoints);
         if (flatten(pixptr, sx, sy, array, npoints, inputimag.blank)){
                     fprintf(stderr, "Error in flatten, can't continue\n");
                      exit (1);
                                                         }
                 }

/* Begin include pass through data */

        if (rmode & F_INCLUDE)
                {
                /* get statistics for image */
                istats (sy,sx, pixptr, &ave, &sig, &bot, &top) ; 
                fprintf(stderr, "stats for image: ave %f sig %f bot %f top %f\n", ave,sig,bot,top);                                       

 /* Set selection window based on either sigma or ptile mode */
 
                if (rmode & F_SIGMA) { /* sigma mode */  
                           uwind = ave+isigu*sig ;    
                           lwind = ave+isigl*sig ;
         fprintf(stderr, "Upper window is : %f \n",uwind);
         fprintf(stderr, "Lower window is : %f \n",lwind);
                                     }
 
                 else               {   /* percentile mode */
 
                res = ave - 5.0*sig; if( bot < res) bot = res ;
                res = ave + 5.0*sig; if( top < res) top = res ;
                res = (top-bot)/nh ;
 
                ihist (sy,sx, pixptr, bot, res, nh, &ntot, &h) ;
                percent = isigl/100. ;
                ptile (nh,h,ntot,percent,&tile) ;
                lwind = tile*res + bot ;
                percent = isigu/100. ;
                ptile (nh,h,ntot,percent,&tile) ;
                uwind = tile*res + bot ;
 
                fprintf(stderr, "Upper window from %f percentile is : %f \n",isigu,uwind);
                fprintf(stderr, "Lower window from %f percentile is : %f \n",isigl,lwind);
                                    }
                      narefs = 0;
                     for (il=0; il < sy; il++ )
                        for (ic=0; ic < sx; ic++)
                        {
                           pixsel = pixptr + ic + il*sx ;
                           val = *pixsel ;
                           if (val <= uwind && val >= lwind)
                           {
                            array[narefs++] = ic+1 ; 
                            array[narefs++] = il+1 ;
                           }
                        }
                     npoints = narefs/2 ;
         fprintf(stderr, "Number of reference points used is: %d\n",npoints);
                 if (flatten(pixptr, sx, sy, array, 
                              npoints, inputimag.blank)){
                     fprintf(stderr, "Error in flatten, can't continue\n");
                      exit (1);
                                                         }
                 }


/* End selection of points, and flatten, create new images */

/* update the header to agree with the new image in the output */

/* add a comment to say what we've done                         */
	 if(debug >5) fprintf(stderr,"Update the header\n");
	sprintf(string,
	  "HISTORY Flattened, planar subtraction (IPAC flatten %s)",
	     history_version); 
	im_wkey_t(outputimag.fid, string, AT_END);

/* The fix-up business goes here...
 *  Get the new datamax and datamin, calculate a new bscale and bzero if
 *  needed etc.  Adjust the rest of the header.
 */
        /* fix-up-function(); */
	hdrclean(pixptr, &outputimag );
/* write the pixel buffer to the output image, and close up shop */
/* Make no more changes to the header after this line!           */

	if(debug >5) fprintf(stderr,"Write the new pixels\n");
	if(im_wpix_r(outputimag.fid, pixptr, npixels) != npixels) 
 		squawk(Terminal, "Error writing pixels to output");

/* we're done! */
	if(debug >5) fprintf(stderr,"Close the images\n");
	if(im_close(inputimag.fid) < 0)
		squawk(Tolerable,"Error closing input image");
	if(im_close(outputimag.fid) < 0)
		squawk(Tolerable,"Error closing output image");

	/* TODO: should free all buffer before exiting */
	free(bufptr); /* free imag memory */
	return(0);  /* Successful Completion */

}
